# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 8
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR8_strategy.txt
# LLM Suggested Fallback: D

def velvet_phoenix(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early rounds: unconditional cooperation
    if current_round <= 3:
        return "C"
    
    # Middle rounds: Tit-for-Tat if opponent ever defected
    if 4 <= current_round <= 7:
        if "D" in opp_history:
            return opp_history[-1]
        else:
            return "C"
    
    # Late rounds: analyze opponent's code for planned defection
    if current_round >= 8:
        if "current_round == 9: return \"D\"" in opponent_program_code or \
           "current_round == 10: return \"D\"" in opponent_program_code:
            return "D"
        elif current_round == 10 and opp_history and opp_history[-1] == "C":
            return "C"
        elif "D" in opp_history:
            return opp_history[-1]
        else:
            return "C"
    
    # Default fallback (shouldn't reach here)
    return "C"